/*
    (C) 1995-96 AROS - The Amiga Research OS
    $Id: 

    Desc: ascii.datatype initialization code.
    Lang: English.
*/
#include <stddef.h>
#include <exec/types.h>
#include <exec/resident.h>
#include <proto/exec.h>
#include <aros/libcall.h>
#include <utility/utility.h>

#ifdef __MORPHOS__
/* For HookEntry */
#include <intuition/classusr.h>
#define CLIB_ALIB_PROTOS_H
#endif

#include "initstruct.h"
#include "ascii_intern.h"
#include "libdefs.h"
#include <aros/debug.h>
#include <aros/asmcall.h>
#include <clib/alib_protos.h>

#include "ascii.datatype_VERSION.h"

#define INIT	AROS_SLIB_ENTRY(init,Ascii)

#ifdef __MORPHOS__
unsigned long __abox__ = 1;
#endif

struct inittable;
extern const char name[];
extern const char version[];
extern const APTR inittabl[4];
extern void *const LIBFUNCTABLE[];
extern const struct inittable datatable;
extern struct AsciiBase_intern *INIT();
extern struct AsciiBase_intern *AROS_SLIB_ENTRY(open,Ascii)();
extern BPTR AROS_SLIB_ENTRY(close,Ascii)();
extern BPTR AROS_SLIB_ENTRY(expunge,Ascii)();
extern int AROS_SLIB_ENTRY(null,Ascii)();
extern const char LIBEND;

#ifdef __MORPHOS__
extern int __UserLibInit(LIBBASETYPEPTR);
extern void __UserLibCleanup(LIBBASETYPEPTR);
#endif

#undef SysBase
#define SysBase (IPB(AsciiBase)->sysbase)


int entry(void)
{
    /* If the library was executed by accident return error code. */
    return -1;
}

const struct Resident resident=
{
    RTC_MATCHWORD,
    (struct Resident *)&resident,
    (APTR)&resident+1,
#ifdef __MORPHOS__
    RTF_PPC | RTF_EXTENDED | RTF_AUTOINIT,
#else
    RTF_AUTOINIT,
#endif
    VERSION,
    NT_LIBRARY,
    0,
    (char *)name,
    (char *)&version[6],
    (ULONG *)inittabl,
#ifdef __MORPHOS__
    REVISION,	/* Revision */
    NULL /* Tags */
#endif
};

const char name[]="ascii.datatype";

const char version[]=VERSTAG;

const APTR inittabl[4]=
{
    (APTR)sizeof(struct AsciiBase_intern),
    (APTR)LIBFUNCTABLE,
#ifdef __MORPHOS__
    NULL,
#else
    (APTR)&datatable,
#endif
    &INIT
};

#ifndef __MORPHOS__
struct inittable
{
    S_CPYO(1,1,B);
    S_CPYO(2,1,L);
    S_CPYO(3,1,B);
    S_CPYO(4,1,W);
    S_CPYO(5,1,W);
    S_CPYO(6,1,L);
    S_END (LIBEND);
};

#define O(n) offsetof(struct AsciiBase_intern,n)

const struct inittable datatable=
{
    { { I_CPYO(1,B,O(library.lib_Node.ln_Type)), { NT_LIBRARY } } },
    { { I_CPYO(1,L,O(library.lib_Node.ln_Name)), { (IPTR)name } } },
    { { I_CPYO(1,B,O(library.lib_Flags       )), { LIBF_SUMUSED|LIBF_CHANGED } } },
    { { I_CPYO(1,W,O(library.lib_Version     )), { VERSION_NUMBER } } },
    { { I_CPYO(1,W,O(library.lib_Revision    )), { REVISION_NUMBER } } },
    { { I_CPYO(1,L,O(library.lib_IdString    )), { (IPTR)&version[6] } } },
  I_END ()
};

#undef O

#endif /* ! __MORPHOS__ */

#undef SysBase

#ifdef __MORPHOS__
struct AsciiBase_intern *LIB_init(struct AsciiBase_intern *LIBBASE, BPTR segList, struct ExecBase *SysBase)
#else
AROS_LH2(struct AsciiBase_intern *, init,
 AROS_LHA(struct AsciiBase_intern *, LIBBASE, D0),
 AROS_LHA(BPTR,               segList,   A0),
     struct ExecBase *, SysBase, 0, BASENAME)
#endif
{
    AROS_LIBFUNC_INIT
    /* This function is single-threaded by exec by calling Forbid. */

#ifdef __MORPHOS__
    LIBBASE->library.lib_Revision = REVISION;
#endif

    /* Store arguments */
    LIBBASE->sysbase=SysBase;
    LIBBASE->seglist=segList;

    if (__UserLibInit(LIBBASE) == 0)
    {
	return LIBBASE;
    }
    else
    {
	FreeMem((char *)LIBBASE-LIBBASE->library.lib_NegSize,
	    LIBBASE->library.lib_NegSize+LIBBASE->library.lib_PosSize);

	return NULL;
    }    
#ifndef __MORPHOS__
    AROS_LIBFUNC_EXIT
#endif
}

/* Use This from now on */
#define SysBase LIBBASE->sysbase

AROS_LH1(struct AsciiBase_intern *, open,
 AROS_LHA(ULONG, version, D0),
     struct AsciiBase_intern *, LIBBASE, 1, BASENAME)
{
    AROS_LIBFUNC_INIT
    /*
	This function is single-threaded by exec by calling Forbid.
	If you break the Forbid() another task may enter this function
	at the same time. Take care.
    */

    /* I have one more opener. */
    LIBBASE->library.lib_OpenCnt++;
    LIBBASE->library.lib_Flags&=~LIBF_DELEXP;

    /* You would return NULL if the open failed. */
    return LIBBASE;
    AROS_LIBFUNC_EXIT
}

AROS_LH0(BPTR, close, struct AsciiBase_intern *, LIBBASE, 2, BASENAME)
{
    AROS_LIBFUNC_INIT
    /*
	This function is single-threaded by exec by calling Forbid.
	If you break the Forbid() another task may enter this function
	at the same time. Take care.
    */

    /* I have one fewer opener. */
    if(!--LIBBASE->library.lib_OpenCnt)
    {
	/* Delayed expunge pending? */
	if(LIBBASE->library.lib_Flags&LIBF_DELEXP)
    	{
	    /* Then expunge the library */
#ifdef __MORPHOS__
    	    return LIB_expunge();
#else
	    return expunge();
#endif
    	}
    }
    return 0;
    AROS_LIBFUNC_EXIT
}

AROS_LH0(BPTR, expunge, struct AsciiBase_intern *, LIBBASE, 3, BASENAME)
{
    AROS_LIBFUNC_INIT

    BPTR ret;
    /*
	This function is single-threaded by exec by calling Forbid.
	Never break the Forbid() or strange things might happen.
    */

    /* Test for openers. */
    if(LIBBASE->library.lib_OpenCnt)
    {
	/* Set the delayed expunge flag and return. */
	LIBBASE->library.lib_Flags|=LIBF_DELEXP;
	return 0;
    }

    __UserLibCleanup(LIBBASE);

    /* Get rid of the library. Remove it from the list. */
    Remove(&LIBBASE->library.lib_Node);

    /* Get returncode here - FreeMem() will destroy the field. */
    ret=LIBBASE->seglist;

    /* Free the memory. */
    FreeMem((char *)LIBBASE-LIBBASE->library.lib_NegSize,
	LIBBASE->library.lib_NegSize+LIBBASE->library.lib_PosSize);

    return ret;
    AROS_LIBFUNC_EXIT
}

AROS_LH0I(int, null, struct AsciiBase_intern *, LIBBASE, 4, BASENAME)
{
    AROS_LIBFUNC_INIT
    return 0;
    AROS_LIBFUNC_EXIT
}


